'use client';

import Image from 'next/image';
import { useLanguage } from '@/contexts/language-context';
import { Card } from '@/components/ui/card';
import { motion } from 'framer-motion';
import { Layers, Shield, DollarSign, ArrowRight } from 'lucide-react';
import Link from 'next/link';

export function ConsortiumInfo() {
  const { content } = useLanguage();
  const { aboutConsortium } = content;

  return (
    <section id="about" className="scroll-mt-20 py-20 relative overflow-hidden bg-gradient-to-br from-slate-50 via-white to-blue-50/20">
       <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[800px] h-[800px] bg-gradient-to-br from-blue-500/5 via-purple-500/5 to-transparent rounded-full blur-3xl"></div>

      <div className="container mx-auto grid grid-cols-1 items-center gap-12 lg:grid-cols-2 relative z-10">
        <motion.div 
            className="order-last lg:order-first"
            initial={{ opacity: 0, x: -30 }}
            whileInView={{ opacity: 1, x: 0 }}
            viewport={{ once: true }}
            transition={{ duration: 0.7 }}
        >
            <div className="inline-flex items-center gap-2 mb-6 px-4 py-2 rounded-full bg-gradient-to-r from-blue-500/10 via-purple-500/10 to-blue-500/10 border border-blue-500/20">
                <Layers className="w-5 h-5 text-blue-600" />
                <span className="text-sm font-bold text-primary">The Power of Synergy</span>
            </div>
          <h2 className="font-headline text-3xl font-bold tracking-tight bg-gradient-to-r from-blue-700 via-primary to-blue-700 bg-clip-text text-transparent sm:text-4xl">
            {aboutConsortium.title}
          </h2>
          <p className="mt-6 text-lg leading-8 text-muted-foreground">
            {aboutConsortium.text}
          </p>
           <div className="mt-8 space-y-4">
                <div className="flex items-center gap-3">
                    <div className="flex h-10 w-10 items-center justify-center rounded-full bg-blue-100"><DollarSign className="h-5 w-5 text-blue-600" /></div>
                    <span className="font-semibold text-primary">Global Infrastructure & Finance</span>
                </div>
                 <div className="flex items-center gap-3">
                    <div className="flex h-10 w-10 items-center justify-center rounded-full bg-purple-100"><Shield className="h-5 w-5 text-purple-600" /></div>
                    <span className="font-semibold text-primary">On-Ground Technical Excellence</span>
                </div>
           </div>
            <Link href="/about">
              <motion.button 
                  className="mt-10 group relative inline-flex items-center justify-center gap-2 overflow-hidden rounded-lg bg-gradient-to-r from-primary to-blue-600 px-6 py-3 font-bold text-white transition-all duration-300 hover:from-blue-600 hover:to-primary"
                  whileHover={{ scale: 1.05 }}
                  whileTap={{ scale: 0.95 }}
              >
                  <span>Learn More</span>
                  <ArrowRight className="h-5 w-5 transition-transform duration-300 group-hover:translate-x-1" />
              </motion.button>
            </Link>
        </motion.div>
        
        <motion.div 
            className="relative"
            initial={{ opacity: 0, x: 30 }}
            whileInView={{ opacity: 1, x: 0 }}
            viewport={{ once: true }}
            transition={{ duration: 0.7 }}
        >
             <div className="absolute -inset-2 bg-gradient-to-br from-blue-500 via-purple-500 to-pink-500 rounded-3xl blur-xl opacity-20"></div>
             <Card className="overflow-hidden shadow-2xl rounded-3xl border-2 border-white/50">
                <div className="aspect-w-16 aspect-h-9 h-[450px] relative">
                    <Image
                      src="/Image_fx (52).jpg"
                      alt="About the Consortium"
                      fill
                      className="object-cover"
                      data-ai-hint="industrial site"
                    />
                    <div className="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent"></div>
                </div>
          </Card>
        </motion.div>
      </div>
    </section>
  );
}
